/*
 * Decompiled with CFR 0.152.
 */
package org.retentionprediction;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.help.HelpSet;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.retentionprediction.AutoScaleEvent;
import org.retentionprediction.AutoScaleListener;
import org.retentionprediction.BackCalculationOptionsDialog;
import org.retentionprediction.Compound;
import org.retentionprediction.Globals;
import org.retentionprediction.InterpolationFunction;
import org.retentionprediction.LinearInterpolationFunction;
import org.retentionprediction.PreloadedValuesDialog;
import org.retentionprediction.TopPanel;
import org.retentionprediction.TopPanel2;

public class RetentionPredictorApplet
extends JApplet
implements ActionListener,
KeyListener,
FocusListener,
ListSelectionListener,
AutoScaleListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    TopPanel contentPane = null;
    TopPanel2 contentPane2 = null;
    public JScrollPane jMainScrollPane = null;
    public JPanel jBackPanel = null;
    public int m_iStationaryPhase = 0;
    public double m_dInitialTemperature = 60.0;
    public double m_dInitialTime = 1.0;
    public double m_dColumnLength = 30.0;
    public double m_dProgramTime = 20.0;
    public double m_dFlowRate = 1.0;
    public double m_dInletPressure = 45.0;
    public double m_dOutletPressure = 1.0E-6;
    public int m_iNumPoints = 3000;
    public Vector<Object[]> m_vectCalCompounds = new Vector();
    private Task task = null;
    private TaskPredict taskPredict = null;
    public int m_iStage = 1;
    public double m_dtstep = 0.01;
    public double m_V0 = 1.0;
    public double[][] m_dIdealTemperatureProfileArray;
    public LinearInterpolationFunction m_InterpolatedIdealTempProfile;
    public LinearInterpolationFunction m_InterpolatedTemperatureProfile;
    public InterpolationFunction m_InitialInterpolatedHoldUpVsTempProfile;
    public double[][] m_dTemperatureProfileArray;
    public double[][] m_dHoldUpArray;
    public InterpolationFunction m_InterpolatedHoldUp;
    public InterpolationFunction[] m_AlkaneIsothermalDataInterpolated;
    public InterpolationFunction[] m_CompoundIsothermalDataInterpolated;
    public InterpolationFunction m_Vm;
    public double[][][] m_dHoldUpArrayStore;
    public double[][][] m_dTemperatureArrayStore;
    public double[] m_dRetentionErrorStore;
    public int m_iInterpolatedTempProgramSeries = 0;
    public int m_iTempProgramMarkerSeries = 0;
    public int m_iInterpolatedHoldUpSeries = 0;
    public int m_iHoldUpMarkerSeries = 0;
    public double m_dPlotXMax = 0.0;
    public double m_dPlotXMax2 = 0.0;
    public boolean m_bDoNotChangeTable = false;
    public final double m_dGoldenRatio = (1.0 + Math.sqrt(5.0)) / 2.0;
    public Vector<Compound> m_vectCompound = new Vector();

    public RetentionPredictorApplet() {
        this.setPreferredSize(new Dimension(943, 615));
    }

    @Override
    public void init() {
        String helpHS = "org/retentionprediction/help/RetentionPredictorHelp.hs";
        ClassLoader cl = TopPanel.class.getClassLoader();
        try {
            URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpHS);
            Globals.hsMainHelpSet = new HelpSet(null, hsURL);
        }
        catch (Exception ee) {
            System.out.println("HelpSet " + ee.getMessage());
            System.out.println("HelpSet " + helpHS + " not found");
            return;
        }
        Globals.hbMainHelpBroker = Globals.hsMainHelpSet.createHelpBroker();
        try {
            this.createGUI();
        }
        catch (Exception e) {
            System.err.println("createGUI didn't complete successfully");
            System.err.println(e.getMessage());
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.toString());
            System.err.println(e.getStackTrace());
            System.err.println(e.getCause());
        }
        this.performValidations();
    }

    private void createGUI() {
        this.jMainScrollPane = new JScrollPane();
        this.jMainScrollPane.setHorizontalScrollBarPolicy(30);
        this.jMainScrollPane.setVerticalScrollBarPolicy(20);
        this.contentPane = new TopPanel();
        this.contentPane.setOpaque(true);
        this.jMainScrollPane.setViewportView(this.contentPane);
        this.setContentPane(this.jMainScrollPane);
        this.jMainScrollPane.revalidate();
        this.contentPane.jtxtInitialTemperature.addFocusListener(this);
        this.contentPane.jtxtInitialTemperature.addKeyListener(this);
        this.contentPane.jtxtInitialTime.addFocusListener(this);
        this.contentPane.jtxtInitialTime.addKeyListener(this);
        this.contentPane.jtxtColumnLength.addFocusListener(this);
        this.contentPane.jtxtColumnLength.addKeyListener(this);
        this.contentPane.jtxtFlowRate.addFocusListener(this);
        this.contentPane.jtxtFlowRate.addKeyListener(this);
        this.contentPane.jtxtPressure.addFocusListener(this);
        this.contentPane.jtxtPressure.addKeyListener(this);
        this.contentPane.jrdoConstantFlowRate.addActionListener(this);
        this.contentPane.jrdoConstantPressure.addActionListener(this);
        this.contentPane.jrdoAmbient.addActionListener(this);
        this.contentPane.jrdoVacuum.addActionListener(this);
        this.contentPane.jbtnHelp.addActionListener(this);
        this.contentPane.jbtnInsertRow.addActionListener(this);
        this.contentPane.jbtnRemoveRow.addActionListener(this);
        this.contentPane.m_GraphControlTemp.addAutoScaleListener(this);
        this.contentPane.m_GraphControlHoldUp.addAutoScaleListener(this);
        this.contentPane.tmTemperatureProgram.addTableModelListener(this);
        this.contentPane.tmMeasuredRetentionTimes.addTableModelListener(this);
        this.contentPane.jbtnNextStep.addActionListener(this);
        this.contentPane.jbtnPreloadedValues.addActionListener(this);
        this.contentPane.m_GraphControlTemp.setYAxisTitle("Column Temperature");
        this.contentPane.m_GraphControlTemp.setYAxisBaseUnit("\u00b0C", "\u00b0C");
        this.contentPane.m_GraphControlTemp.setYAxisRangeLimits(0.0, 105.0);
        this.contentPane.m_GraphControlTemp.setYAxisRangeIndicatorsVisible(true);
        this.contentPane.m_GraphControlTemp.setXAxisRangeIndicatorsVisible(false);
        this.contentPane.m_GraphControlTemp.setAutoScaleY(true);
        this.contentPane.m_GraphControlTemp.repaint();
        this.contentPane.m_GraphControlHoldUp.setYAxisTitle("Hold-up Time");
        this.contentPane.m_GraphControlHoldUp.setYAxisBaseUnit("seconds", "s");
        this.contentPane.m_GraphControlHoldUp.setYAxisRangeLimits(0.0, 10000.0);
        this.contentPane.m_GraphControlHoldUp.setYAxisRangeIndicatorsVisible(true);
        this.contentPane.m_GraphControlHoldUp.setXAxisRangeIndicatorsVisible(false);
        this.contentPane.m_GraphControlHoldUp.setAutoScaleY(true);
        this.contentPane.m_GraphControlHoldUp.repaint();
        this.contentPane2 = new TopPanel2();
        this.contentPane2.setOpaque(true);
        this.contentPane2.jpanelStep6.setVisible(false);
        this.contentPane2.jbtnCalculate.addActionListener(this);
        this.contentPane2.jbtnNextStep.addActionListener(this);
        this.contentPane2.jbtnPreviousStep.addActionListener(this);
        this.contentPane2.jbtnPredict.addActionListener(this);
        this.contentPane2.jbtnHelp.addActionListener(this);
        this.contentPane2.m_GraphControlTemp.setYAxisTitle("Column Temperature");
        this.contentPane2.m_GraphControlTemp.setYAxisBaseUnit("\u00b0C", "\u00b0C");
        this.contentPane2.m_GraphControlTemp.setYAxisRangeLimits(0.0, 105.0);
        this.contentPane2.m_GraphControlTemp.setYAxisRangeIndicatorsVisible(true);
        this.contentPane2.m_GraphControlTemp.setXAxisRangeIndicatorsVisible(false);
        this.contentPane2.m_GraphControlTemp.setAutoScaleY(true);
        this.contentPane2.m_GraphControlTemp.repaint();
        this.contentPane2.m_GraphControlHoldUp.setYAxisTitle("Hold-up Time");
        this.contentPane2.m_GraphControlHoldUp.setYAxisBaseUnit("seconds", "s");
        this.contentPane2.m_GraphControlHoldUp.setYAxisRangeLimits(0.0, 100.0);
        this.contentPane2.m_GraphControlHoldUp.setYAxisRangeIndicatorsVisible(true);
        this.contentPane2.m_GraphControlHoldUp.setAutoScaleY(true);
        this.contentPane2.m_GraphControlHoldUp.setXAxisType(false);
        this.contentPane2.m_GraphControlHoldUp.setXAxisBaseUnit("\u00b0C", "\u00b0C");
        this.contentPane2.m_GraphControlHoldUp.setXAxisRangeLimits(0.0, 1000.0);
        this.contentPane2.m_GraphControlHoldUp.setXAxisTitle("Temperature");
        this.contentPane2.m_GraphControlHoldUp.setXAxisRangeIndicatorsVisible(false);
        this.contentPane2.m_GraphControlHoldUp.repaint();
    }

    private void validateInitialTemperature() {
        double dFirstTemp;
        double dTemp = Float.valueOf(this.contentPane.jtxtInitialTemperature.getText()).floatValue();
        if (dTemp < 0.0) {
            dTemp = 0.0;
        }
        if (dTemp > 500.0) {
            dTemp = 500.0;
        }
        if (this.contentPane.tmTemperatureProgram.getRowCount() > 0 && dTemp > (dFirstTemp = ((Double)this.contentPane.tmTemperatureProgram.getValueAt(0, 1)).doubleValue())) {
            dTemp = dFirstTemp;
        }
        this.m_dInitialTemperature = dTemp;
        this.contentPane.jtxtInitialTemperature.setText(Float.toString((float)dTemp));
    }

    private void validateInitialTime() {
        double dTemp = Float.valueOf(this.contentPane.jtxtInitialTime.getText()).floatValue();
        if (dTemp < 0.0) {
            dTemp = 0.0;
        }
        if (dTemp > 1000.0) {
            dTemp = 1000.0;
        }
        this.m_dInitialTime = dTemp;
        this.contentPane.jtxtInitialTime.setText(Float.toString((float)dTemp));
    }

    private void validateColumnLength() {
        double dTemp = Float.valueOf(this.contentPane.jtxtColumnLength.getText()).floatValue();
        if (dTemp < 0.1) {
            dTemp = 0.1;
        }
        if (dTemp > 10000.0) {
            dTemp = 10000.0;
        }
        this.m_dColumnLength = dTemp;
        this.contentPane.jtxtColumnLength.setText(Float.toString((float)this.m_dColumnLength));
    }

    private void validateFlowRate() {
        double dTemp = Float.valueOf(this.contentPane.jtxtFlowRate.getText()).floatValue();
        if (dTemp < 1.0E-9) {
            dTemp = 1.0E-9;
        }
        if (dTemp > 10000.0) {
            dTemp = 10000.0;
        }
        this.m_dFlowRate = dTemp;
        this.contentPane.jtxtFlowRate.setText(Float.toString((float)this.m_dFlowRate));
    }

    private void validateInletPressure() {
        double dTemp = Float.valueOf(this.contentPane.jtxtPressure.getText()).floatValue();
        if (dTemp < 1.0E-9) {
            dTemp = 1.0E-9;
        }
        if (dTemp > 100000.0) {
            dTemp = 100000.0;
        }
        this.m_dInletPressure = dTemp;
        this.contentPane.jtxtPressure.setText(Float.toString((float)this.m_dInletPressure));
    }

    public void nextStepButtonPressed() {
        int iNumTempProgramDataPoints;
        if (this.contentPane.jtableMeasuredRetentionTimes.isEditing()) {
            this.contentPane.jtableMeasuredRetentionTimes.getCellEditor().stopCellEditing();
        }
        this.m_iStage = 2;
        DecimalFormat formatter = new DecimalFormat("#0.0000");
        this.contentPane2.jbtnCalculate.setText("Back-Calculate Profiles");
        this.contentPane2.jbtnCalculate.setEnabled(true);
        this.contentPane2.jlblIterationNumber.setText("1");
        this.contentPane2.jlblLastVariance.setText("");
        this.contentPane2.jlblPercentImprovement.setText("");
        this.contentPane2.jlblPhase.setText("I");
        this.contentPane2.jlblTimeElapsed.setText("");
        this.contentPane2.jlblVariance.setText("");
        this.contentPane2.jProgressBar.setString("");
        this.contentPane2.jProgressBar.setIndeterminate(false);
        this.contentPane2.jbtnNextStep.setEnabled(false);
        this.contentPane2.m_GraphControlTemp.RemoveAllSeries();
        this.contentPane2.m_GraphControlHoldUp.RemoveAllSeries();
        this.contentPane2.jpanelStep6.setVisible(false);
        this.contentPane2.jpanelStep5.setVisible(true);
        this.contentPane2.tmOutputModel.getDataVector().clear();
        this.m_vectCalCompounds.clear();
        int i = 0;
        while (i < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
            if (!((Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3) <= Double.valueOf(0.0)) && ((Boolean)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 0)).booleanValue()) {
                Object[] objectArray = new Object[4];
                objectArray[0] = this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1);
                objectArray[1] = formatter.format(this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3));
                Object[] newRow = objectArray;
                this.contentPane2.tmOutputModel.addRow(newRow);
                Object[] newSolute = new Object[]{i, this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3), 0.0};
                this.m_vectCalCompounds.add(newSolute);
            }
            ++i;
        }
        this.m_dPlotXMax2 = (Double)this.m_vectCalCompounds.get(this.m_vectCalCompounds.size() - 1)[1];
        this.m_dtstep = this.m_dPlotXMax2 * 0.001;
        int iIdealPlotIndexTemp = this.contentPane2.m_GraphControlTemp.AddSeries("Ideal Temperature Program", new Color(0, 0, 0), 1, false, false);
        int iIdealPlotIndexHoldUp = this.contentPane2.m_GraphControlHoldUp.AddSeries("Ideal Hold-up Time", new Color(0, 0, 0), 1, false, false);
        this.m_iInterpolatedTempProgramSeries = this.contentPane2.m_GraphControlTemp.AddSeries("Interpolated Temperature Program", new Color(255, 0, 0), 1, false, false);
        this.m_iTempProgramMarkerSeries = this.contentPane2.m_GraphControlTemp.AddSeries("Temp Program Markers", new Color(255, 0, 0), 1, true, false);
        this.m_iInterpolatedHoldUpSeries = this.contentPane2.m_GraphControlHoldUp.AddSeries("Interpolated Hold-up", new Color(255, 0, 0), 1, false, false);
        this.m_iHoldUpMarkerSeries = this.contentPane2.m_GraphControlHoldUp.AddSeries("Hold-up Markers", new Color(255, 0, 0), 1, true, false);
        this.m_dIdealTemperatureProfileArray = new double[this.contentPane.tmTemperatureProgram.getRowCount() * 2 + 2][2];
        int iPointCount = 0;
        this.contentPane2.m_GraphControlTemp.AddDataPoint(iIdealPlotIndexTemp, 0.0, this.m_dInitialTemperature);
        this.m_dIdealTemperatureProfileArray[iPointCount][0] = 0.0;
        this.m_dIdealTemperatureProfileArray[iPointCount][1] = this.m_dInitialTemperature;
        this.contentPane2.m_GraphControlTemp.AddDataPoint(iIdealPlotIndexTemp, this.m_dInitialTime * 60.0, this.m_dInitialTemperature);
        this.m_dIdealTemperatureProfileArray[++iPointCount][0] = this.m_dInitialTime;
        this.m_dIdealTemperatureProfileArray[iPointCount][1] = this.m_dInitialTemperature;
        ++iPointCount;
        double dTotalTime = this.m_dInitialTime;
        double dLastTemp = this.m_dInitialTemperature;
        double dFinalTemp = this.m_dInitialTemperature;
        int i2 = 0;
        while (i2 < this.contentPane.tmTemperatureProgram.getRowCount()) {
            double dRamp = (Double)this.contentPane.tmTemperatureProgram.getValueAt(i2, 0);
            dFinalTemp = (Double)this.contentPane.tmTemperatureProgram.getValueAt(i2, 1);
            double dFinalTime = (Double)this.contentPane.tmTemperatureProgram.getValueAt(i2, 2);
            if (dRamp != 0.0) {
                this.contentPane2.m_GraphControlTemp.AddDataPoint(iIdealPlotIndexTemp, (dTotalTime += (dFinalTemp - dLastTemp) / dRamp) * 60.0, dFinalTemp);
                this.m_dIdealTemperatureProfileArray[iPointCount][0] = dTotalTime;
                this.m_dIdealTemperatureProfileArray[iPointCount][1] = dFinalTemp;
                ++iPointCount;
            }
            if (dFinalTime != 0.0 && i2 < this.contentPane.tmTemperatureProgram.getRowCount() - 1) {
                this.contentPane2.m_GraphControlTemp.AddDataPoint(iIdealPlotIndexTemp, (dTotalTime += dFinalTime) * 60.0, dFinalTemp);
                this.m_dIdealTemperatureProfileArray[iPointCount][0] = dTotalTime;
                this.m_dIdealTemperatureProfileArray[iPointCount][1] = dFinalTemp;
                ++iPointCount;
            }
            dLastTemp = dFinalTemp;
            ++i2;
        }
        this.contentPane2.m_GraphControlTemp.AddDataPoint(iIdealPlotIndexTemp, this.m_dPlotXMax2 * 60.0, dFinalTemp);
        this.m_dIdealTemperatureProfileArray[iPointCount][0] = this.m_dPlotXMax2;
        this.m_dIdealTemperatureProfileArray[iPointCount][1] = dFinalTemp;
        double[][] tempArray = new double[++iPointCount][2];
        int i3 = 0;
        while (i3 < iPointCount) {
            tempArray[i3][0] = this.m_dIdealTemperatureProfileArray[i3][0];
            tempArray[i3][1] = this.m_dIdealTemperatureProfileArray[i3][1];
            ++i3;
        }
        this.m_dIdealTemperatureProfileArray = tempArray;
        this.m_InterpolatedIdealTempProfile = new LinearInterpolationFunction(this.m_dIdealTemperatureProfileArray);
        int iTotalDataPoints = this.m_vectCalCompounds.size();
        int iNumFlowDataPoints = iTotalDataPoints - (iNumTempProgramDataPoints = (int)(0.7333333333333333 * (double)iTotalDataPoints));
        if (iNumFlowDataPoints < 3) {
            iNumFlowDataPoints = 3;
            iNumTempProgramDataPoints = iTotalDataPoints - iNumFlowDataPoints;
        }
        this.m_dTemperatureProfileArray = new double[iNumTempProgramDataPoints][2];
        this.m_dHoldUpArray = new double[iNumFlowDataPoints][2];
        this.m_dTemperatureProfileArray[0][0] = 0.0;
        this.m_dTemperatureProfileArray[0][1] = this.m_InterpolatedIdealTempProfile.getAt(this.m_dTemperatureProfileArray[0][0]);
        int i4 = 1;
        while (i4 < iNumTempProgramDataPoints - 1) {
            double dAlkaneNum = (double)i4 / ((double)iNumTempProgramDataPoints - 1.0) * (double)iTotalDataPoints;
            double dOneGreater = (int)Math.ceil(dAlkaneNum);
            double dOneLesser = (int)Math.floor(dAlkaneNum);
            double dRtOneLesser = (Double)this.m_vectCalCompounds.get((int)dOneLesser)[1];
            double dRtOneGreater = (Double)this.m_vectCalCompounds.get((int)dOneGreater)[1];
            if (dOneGreater == dOneLesser) {
                this.m_dTemperatureProfileArray[i4][0] = dRtOneLesser;
            } else {
                double dPosition = (dAlkaneNum - dOneLesser) / (dOneGreater - dOneLesser);
                this.m_dTemperatureProfileArray[i4][0] = dPosition * dRtOneGreater + (1.0 - dPosition) * dRtOneLesser;
            }
            this.m_dTemperatureProfileArray[i4][0] = this.m_dTemperatureProfileArray[i4][0] - 0.5 * (this.m_InitialInterpolatedHoldUpVsTempProfile.getAt(this.m_InterpolatedIdealTempProfile.getAt(this.m_dTemperatureProfileArray[i4][0])) / 60.0);
            this.m_dTemperatureProfileArray[i4][1] = this.m_InterpolatedIdealTempProfile.getAt(this.m_dTemperatureProfileArray[i4][0]);
            ++i4;
        }
        this.m_dTemperatureProfileArray[iNumTempProgramDataPoints - 1][0] = (Double)this.m_vectCalCompounds.get(this.m_vectCalCompounds.size() - 1)[1];
        this.m_dTemperatureProfileArray[iNumTempProgramDataPoints - 1][1] = this.m_InterpolatedIdealTempProfile.getAt(this.m_dTemperatureProfileArray[iNumTempProgramDataPoints - 1][0]);
        int iPointIndex = 1;
        int i5 = 1;
        while (i5 < this.m_dIdealTemperatureProfileArray.length - 1) {
            double dDistNextAfter;
            double dScoreNext;
            double dDistFirstBefore;
            double dScoreFirst;
            double dFirst = 0.0;
            double dNext = 0.0;
            while (dNext < this.m_dIdealTemperatureProfileArray[i5][0] && iPointIndex < this.m_dTemperatureProfileArray.length - 1) {
                dFirst = this.m_dTemperatureProfileArray[iPointIndex][0];
                dNext = this.m_dTemperatureProfileArray[iPointIndex + 1][0];
                ++iPointIndex;
            }
            double dDistFirst = this.m_dIdealTemperatureProfileArray[i5][0] - dFirst;
            double dDistNext = dNext - this.m_dIdealTemperatureProfileArray[i5][0];
            if ((dScoreFirst = dDistFirst + (dDistFirstBefore = this.m_dTemperatureProfileArray[--iPointIndex][0] - this.m_dTemperatureProfileArray[iPointIndex - 1][0])) < (dScoreNext = dDistNext + (dDistNextAfter = iPointIndex + 2 < this.m_dTemperatureProfileArray.length ? this.m_dTemperatureProfileArray[iPointIndex + 2][0] - this.m_dTemperatureProfileArray[iPointIndex + 1][0] : 0.0))) {
                this.m_dTemperatureProfileArray[iPointIndex][0] = this.m_dIdealTemperatureProfileArray[i5][0];
                this.m_dTemperatureProfileArray[iPointIndex][1] = this.m_InterpolatedIdealTempProfile.getAt(this.m_dTemperatureProfileArray[iPointIndex][0]);
                if (iPointIndex >= 2) {
                    this.m_dTemperatureProfileArray[iPointIndex - 1][0] = (this.m_dTemperatureProfileArray[iPointIndex - 2][0] + this.m_dTemperatureProfileArray[iPointIndex][0]) / 2.0;
                    this.m_dTemperatureProfileArray[iPointIndex - 1][1] = this.m_InterpolatedIdealTempProfile.getAt(this.m_dTemperatureProfileArray[iPointIndex - 1][0]);
                }
                if (iPointIndex <= this.m_dTemperatureProfileArray.length - 3) {
                    this.m_dTemperatureProfileArray[iPointIndex + 1][0] = (this.m_dTemperatureProfileArray[iPointIndex][0] + this.m_dTemperatureProfileArray[iPointIndex + 2][0]) / 2.0;
                    this.m_dTemperatureProfileArray[iPointIndex + 1][1] = this.m_InterpolatedIdealTempProfile.getAt(this.m_dTemperatureProfileArray[iPointIndex + 1][0]);
                }
            } else {
                this.m_dTemperatureProfileArray[iPointIndex + 1][0] = this.m_dIdealTemperatureProfileArray[i5][0];
                this.m_dTemperatureProfileArray[iPointIndex + 1][1] = this.m_InterpolatedIdealTempProfile.getAt(this.m_dTemperatureProfileArray[iPointIndex + 1][0]);
                if (iPointIndex >= 1) {
                    this.m_dTemperatureProfileArray[iPointIndex][0] = (this.m_dTemperatureProfileArray[iPointIndex - 1][0] + this.m_dTemperatureProfileArray[iPointIndex + 1][0]) / 2.0;
                    this.m_dTemperatureProfileArray[iPointIndex][1] = this.m_InterpolatedIdealTempProfile.getAt(this.m_dTemperatureProfileArray[iPointIndex][0]);
                }
                if (iPointIndex <= this.m_dTemperatureProfileArray.length - 4) {
                    this.m_dTemperatureProfileArray[iPointIndex + 2][0] = (this.m_dTemperatureProfileArray[iPointIndex + 1][0] + this.m_dTemperatureProfileArray[iPointIndex + 3][0]) / 2.0;
                    this.m_dTemperatureProfileArray[iPointIndex + 2][1] = this.m_InterpolatedIdealTempProfile.getAt(this.m_dTemperatureProfileArray[iPointIndex + 2][0]);
                }
            }
            ++i5;
        }
        double dMinTemp = this.m_dIdealTemperatureProfileArray[0][1];
        double dMaxTemp = this.m_dIdealTemperatureProfileArray[this.m_dIdealTemperatureProfileArray.length - 1][1];
        int iNumPoints = 1000;
        int i6 = 0;
        while (i6 < iNumPoints) {
            double dXPos = (double)i6 / (double)(iNumPoints - 1) * (dMaxTemp - dMinTemp) + dMinTemp;
            this.contentPane2.m_GraphControlHoldUp.AddDataPoint(iIdealPlotIndexHoldUp, dXPos, this.m_InitialInterpolatedHoldUpVsTempProfile.getAt(dXPos));
            ++i6;
        }
        i6 = 0;
        while (i6 < iNumFlowDataPoints) {
            this.m_dHoldUpArray[i6][0] = (dMaxTemp - dMinTemp) * ((double)i6 / ((double)iNumFlowDataPoints - 1.0)) + dMinTemp;
            this.m_dHoldUpArray[i6][1] = this.m_InitialInterpolatedHoldUpVsTempProfile.getAt(this.m_dHoldUpArray[i6][0]);
            ++i6;
        }
        this.m_InterpolatedTemperatureProfile = new LinearInterpolationFunction(this.m_dTemperatureProfileArray);
        this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
        this.jMainScrollPane.setViewportView(this.contentPane2);
        this.updateGraphs(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String strActionCommand = evt.getActionCommand();
        if (strActionCommand == "Help") {
            Globals.hbMainHelpBroker.setCurrentID("step-by-step");
            Globals.hbMainHelpBroker.setDisplayed(true);
        } else if (strActionCommand == "Next Step") {
            this.nextStepButtonPressed();
        } else if (strActionCommand == "Previous Step") {
            if (this.m_iStage == 2) {
                this.jMainScrollPane.setViewportView(this.contentPane);
                if (this.task != null) {
                    this.task.cancel(true);
                }
                this.m_iStage = 1;
            } else if (this.m_iStage == 3) {
                if (this.taskPredict != null) {
                    this.taskPredict.cancel(true);
                }
                this.contentPane2.jpanelStep6.setVisible(false);
                this.contentPane2.jpanelStep5.setVisible(true);
                this.contentPane2.jbtnNextStep.setVisible(true);
                this.m_iStage = 2;
            }
        } else if (strActionCommand == "Calculate") {
            Frame[] frames = Frame.getFrames();
            BackCalculationOptionsDialog dlgBackCalculationOptions = new BackCalculationOptionsDialog(frames[0]);
            dlgBackCalculationOptions.setVisible(true);
            if (!dlgBackCalculationOptions.m_bOk) {
                return;
            }
            this.beginBackCalculation(dlgBackCalculationOptions.m_bFlowRateProfileFirst);
        } else if (strActionCommand == "Stop Calculations") {
            this.task.cancel(true);
        } else if (strActionCommand == "Next Step2") {
            this.contentPane2.tmPredictionModel.getDataVector().clear();
            int i = 0;
            while (i < Globals.CompoundIsothermalDataArray.length) {
                Object[] objectArray = new Object[2];
                objectArray[0] = Globals.CompoundNameArray[i];
                Object[] newRow = objectArray;
                this.contentPane2.tmPredictionModel.addRow(newRow);
                ++i;
            }
            this.contentPane2.jpanelStep5.setVisible(false);
            this.contentPane2.jpanelStep6.setVisible(true);
            this.contentPane2.jbtnNextStep.setVisible(false);
            this.contentPane2.jbtnPredict.setEnabled(true);
            this.contentPane2.jProgressBar2.setString("");
            this.contentPane2.jProgressBar2.setIndeterminate(false);
            ++this.m_iStage;
        } else if (strActionCommand == "Predict") {
            this.contentPane2.jbtnPredict.setEnabled(false);
            this.contentPane2.jProgressBar2.setIndeterminate(true);
            this.contentPane2.jProgressBar2.setStringPainted(true);
            this.contentPane2.jProgressBar2.setString("Please wait, calculating retention...");
            this.taskPredict = new TaskPredict();
            this.taskPredict.execute();
        } else if (strActionCommand == "Preloaded Values") {
            Frame[] frames = Frame.getFrames();
            PreloadedValuesDialog dlgPreloadedValues = new PreloadedValuesDialog(frames[0]);
            dlgPreloadedValues.setVisible(true);
            if (!dlgPreloadedValues.m_bOk) {
                return;
            }
            if (Globals.dTemperaturePrograms[dlgPreloadedValues.m_iCondition][0][0] == 0.0) {
                this.switchToConstantFlowRateMode();
                this.contentPane.jtxtFlowRate.setText(Double.valueOf(Globals.dTemperaturePrograms[dlgPreloadedValues.m_iCondition][0][1]).toString());
            } else {
                this.switchToConstantPressureMode();
                this.contentPane.jtxtPressure.setText(Double.valueOf(Globals.dTemperaturePrograms[dlgPreloadedValues.m_iCondition][0][1]).toString());
            }
            if (Globals.dTemperaturePrograms[dlgPreloadedValues.m_iCondition][0][2] == 0.0) {
                this.vacuumOutletPressure();
            } else {
                this.ambientOutletPressure();
            }
            this.contentPane.jtxtColumnLength.setText(Double.valueOf(Globals.dTemperaturePrograms[dlgPreloadedValues.m_iCondition][0][3]).toString());
            this.contentPane.jtxtInitialTemperature.setText(Double.valueOf(Globals.dTemperaturePrograms[dlgPreloadedValues.m_iCondition][1][0]).toString());
            this.contentPane.jtxtInitialTime.setText(Double.valueOf(Globals.dTemperaturePrograms[dlgPreloadedValues.m_iCondition][1][1]).toString());
            this.m_bDoNotChangeTable = true;
            this.contentPane.tmTemperatureProgram.setRowCount(0);
            int i = 2;
            while (i < Globals.dTemperaturePrograms[dlgPreloadedValues.m_iCondition].length) {
                Object[] rowData = new Object[]{Globals.dTemperaturePrograms[dlgPreloadedValues.m_iCondition][i][0], Globals.dTemperaturePrograms[dlgPreloadedValues.m_iCondition][i][1], Globals.dTemperaturePrograms[dlgPreloadedValues.m_iCondition][i][2]};
                this.contentPane.tmTemperatureProgram.addRow(rowData);
                ++i;
            }
            i = 0;
            while (i < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
                this.contentPane.tmMeasuredRetentionTimes.setValueAt(0.0, i, 3);
                ++i;
            }
            i = 0;
            while (i < Globals.dPredefinedValues[dlgPreloadedValues.m_iCondition].length) {
                this.contentPane.tmMeasuredRetentionTimes.setValueAt(Globals.dPredefinedValues[dlgPreloadedValues.m_iCondition][i], i, 3);
                if (Globals.dPredefinedValues[dlgPreloadedValues.m_iCondition][i] > 0.0) {
                    this.contentPane.tmMeasuredRetentionTimes.setValueAt(true, i, 0);
                } else {
                    this.contentPane.tmMeasuredRetentionTimes.setValueAt(false, i, 0);
                }
                ++i;
            }
            this.performValidations();
        } else if (strActionCommand == "Insert Row") {
            int iSelectedRow = this.contentPane.jtblTemperatureProgram.getSelectedRow();
            if (this.contentPane.jtblTemperatureProgram.getRowCount() == 0) {
                Double dRowValue1 = 20.0;
                Double dRowValue2 = this.m_dInitialTemperature;
                Double dRowValue3 = 5.0;
                Object[] dRowData = new Double[]{dRowValue1, dRowValue2, dRowValue3};
                this.contentPane.tmTemperatureProgram.addRow(dRowData);
            } else if (iSelectedRow == -1) {
                Double dRowValue1 = 0.0;
                Double dRowValue2 = (Double)this.contentPane.jtblTemperatureProgram.getValueAt(this.contentPane.jtblTemperatureProgram.getRowCount() - 1, 1);
                Double dRowValue3 = 5.0;
                Object[] dRowData = new Double[]{dRowValue1, dRowValue2, dRowValue3};
                this.contentPane.tmTemperatureProgram.addRow(dRowData);
            } else {
                Double dRowValue1 = 0.0;
                Double dRowValue2 = (Double)this.contentPane.jtblTemperatureProgram.getValueAt(iSelectedRow, 1);
                Double dRowValue3 = 5.0;
                Object[] dRowData = new Double[]{dRowValue1, dRowValue2, dRowValue3};
                this.contentPane.tmTemperatureProgram.insertRow(iSelectedRow, dRowData);
            }
        } else if (strActionCommand == "Remove Row") {
            int iSelectedRow = this.contentPane.jtblTemperatureProgram.getSelectedRow();
            if (iSelectedRow == -1) {
                iSelectedRow = this.contentPane.jtblTemperatureProgram.getRowCount() - 1;
            }
            if (iSelectedRow >= 0) {
                this.contentPane.tmTemperatureProgram.removeRow(iSelectedRow);
            }
        } else if (strActionCommand == "Constant flow rate mode") {
            this.switchToConstantFlowRateMode();
        } else if (strActionCommand == "Constant pressure mode") {
            this.switchToConstantPressureMode();
        } else if (strActionCommand == "Vacuum") {
            this.vacuumOutletPressure();
        } else if (strActionCommand == "Ambient") {
            this.ambientOutletPressure();
        }
    }

    public void vacuumOutletPressure() {
        this.contentPane.jrdoVacuum.setSelected(true);
        this.contentPane.jrdoAmbient.setSelected(false);
        this.m_dOutletPressure = 1.0E-6;
        this.performValidations();
    }

    public void ambientOutletPressure() {
        this.contentPane.jrdoVacuum.setSelected(false);
        this.contentPane.jrdoAmbient.setSelected(true);
        this.m_dOutletPressure = 100.0;
        this.performValidations();
    }

    public void switchToConstantPressureMode() {
        this.contentPane.jrdoConstantPressure.setSelected(true);
        this.contentPane.jrdoConstantFlowRate.setSelected(false);
        this.contentPane.jlblFlowRate.setEnabled(false);
        this.contentPane.jlblFlowRateUnit.setEnabled(false);
        this.contentPane.jtxtFlowRate.setEnabled(false);
        this.contentPane.jlblPressure.setEnabled(true);
        this.contentPane.jtxtPressure.setEnabled(true);
        this.contentPane.jlblPressureUnit.setEnabled(true);
        this.performValidations();
    }

    public void switchToConstantFlowRateMode() {
        this.contentPane.jrdoConstantFlowRate.setSelected(true);
        this.contentPane.jrdoConstantPressure.setSelected(false);
        this.contentPane.jlblFlowRate.setEnabled(true);
        this.contentPane.jlblFlowRateUnit.setEnabled(true);
        this.contentPane.jtxtFlowRate.setEnabled(true);
        this.contentPane.jlblPressure.setEnabled(false);
        this.contentPane.jtxtPressure.setEnabled(false);
        this.contentPane.jlblPressureUnit.setEnabled(false);
        this.performValidations();
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!Character.isDigit(e.getKeyChar()) && e.getKeyChar() != '\b' && e.getKeyChar() != '\u007f' && e.getKeyChar() != '.') {
            e.consume();
        }
        if (e.getKeyChar() == '\n') {
            this.performValidations();
        }
    }

    public void performValidations() {
        this.validateInitialTemperature();
        this.validateInitialTime();
        this.validateColumnLength();
        this.validateFlowRate();
        this.validateInletPressure();
        double dInnerDiameter = 0.025;
        this.m_V0 = Math.PI * Math.pow(dInnerDiameter / 2.0, 2.0) * (this.m_dColumnLength * 100.0) / 1000.0;
        int iNumPoints = 10;
        double dLowTemp = 0.0;
        double dHighTemp = 500.0;
        double[][] dHoldUpArray = new double[iNumPoints][2];
        int i = 0;
        while (i < iNumPoints) {
            dHoldUpArray[i][0] = (dHighTemp - dLowTemp) * ((double)i / (double)(iNumPoints - 1)) + dLowTemp;
            double dGasViscosity = 18.69 * Math.pow(10.0, -6.0) * Math.pow((dHoldUpArray[i][0] + 273.15) / 273.15, 0.6958 + -0.0071 * ((dHoldUpArray[i][0] + 273.15 - 273.15) / 273.15));
            double dOmega = this.m_dColumnLength * dGasViscosity * (32.0 / Math.pow(dInnerDiameter / 100.0, 2.0));
            double dDeadTime = 0.0;
            if (this.contentPane.jrdoConstantFlowRate.isSelected()) {
                double dFirstTerm = Math.pow(Math.PI, 2.0) * Math.pow(dInnerDiameter / 10.0, 4.0) * Math.pow(this.m_dOutletPressure * 1000.0, 3.0) / (1536.0 * dGasViscosity * Math.pow(101325.0, 2.0) * Math.pow((dHoldUpArray[i][0] + 273.15) / 298.15 * (this.m_dFlowRate / 60000.0 / (dInnerDiameter / 10.0)), 2.0));
                double dSecondTerm = Math.pow(1.0 + 256.0 * this.m_dColumnLength * dGasViscosity * 101325.0 * ((dHoldUpArray[i][0] + 273.15) / 298.15 * (this.m_dFlowRate / 60000.0 / (dInnerDiameter / 100.0))) / (Math.PI * Math.pow(dInnerDiameter / 10.0, 3.0) * Math.pow(this.m_dOutletPressure * 1000.0, 2.0)), 1.5) - 1.0;
                dDeadTime = dFirstTerm * dSecondTerm;
            } else {
                dDeadTime = 4.0 * dOmega * this.m_dColumnLength * (Math.pow(this.m_dInletPressure * 1000.0 + 101325.0, 3.0) - Math.pow(this.m_dOutletPressure * 1000.0, 3.0)) / (3.0 * Math.pow(Math.pow(this.m_dInletPressure * 1000.0 + 101325.0, 2.0) - Math.pow(this.m_dOutletPressure * 1000.0, 2.0), 2.0));
            }
            dHoldUpArray[i][1] = dDeadTime;
            ++i;
        }
        this.m_InitialInterpolatedHoldUpVsTempProfile = new InterpolationFunction(dHoldUpArray);
        double dMax = 0.0;
        int i2 = 0;
        while (i2 < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
            double dValue = (Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i2, 3);
            if (dValue > dMax) {
                dMax = dValue;
            }
            ++i2;
        }
        double dTotalTime = this.m_dInitialTime;
        double dLastTemp = this.m_dInitialTemperature;
        int i3 = 0;
        while (i3 < this.contentPane.tmTemperatureProgram.getRowCount()) {
            double dRamp = (Double)this.contentPane.tmTemperatureProgram.getValueAt(i3, 0);
            double dFinalTemp = (Double)this.contentPane.tmTemperatureProgram.getValueAt(i3, 1);
            double dFinalTime = (Double)this.contentPane.tmTemperatureProgram.getValueAt(i3, 2);
            if (dRamp != 0.0) {
                dTotalTime += (dFinalTemp - dLastTemp) / dRamp;
            }
            dTotalTime += dFinalTime;
            dLastTemp = dFinalTemp;
            ++i3;
        }
        this.m_dPlotXMax = Math.max(dTotalTime * 1.2, dMax * 1.02);
        this.contentPane.m_GraphControlTemp.RemoveAllSeries();
        this.contentPane.m_GraphControlHoldUp.RemoveAllSeries();
        int iIdealPlotIndex = this.contentPane.m_GraphControlTemp.AddSeries("Ideal Gradient", new Color(0, 0, 0), 1, false, false);
        int iIdealPlotIndexHoldUp = this.contentPane.m_GraphControlHoldUp.AddSeries("Ideal Hold Up", new Color(0, 0, 0), 1, false, false);
        this.contentPane.m_GraphControlTemp.AddDataPoint(iIdealPlotIndex, 0.0, this.m_dInitialTemperature);
        this.contentPane.m_GraphControlHoldUp.AddDataPoint(iIdealPlotIndexHoldUp, 0.0, this.m_InitialInterpolatedHoldUpVsTempProfile.getAt(this.m_dInitialTemperature));
        this.contentPane.m_GraphControlTemp.AddDataPoint(iIdealPlotIndex, this.m_dInitialTime * 60.0, this.m_dInitialTemperature);
        this.contentPane.m_GraphControlHoldUp.AddDataPoint(iIdealPlotIndexHoldUp, this.m_dInitialTime * 60.0, this.m_InitialInterpolatedHoldUpVsTempProfile.getAt(this.m_dInitialTemperature));
        dTotalTime = this.m_dInitialTime;
        dLastTemp = this.m_dInitialTemperature;
        double dFinalTemp = this.m_dInitialTemperature;
        int i4 = 0;
        while (i4 < this.contentPane.tmTemperatureProgram.getRowCount()) {
            double dRamp = (Double)this.contentPane.tmTemperatureProgram.getValueAt(i4, 0);
            dFinalTemp = (Double)this.contentPane.tmTemperatureProgram.getValueAt(i4, 1);
            double dFinalTime = (Double)this.contentPane.tmTemperatureProgram.getValueAt(i4, 2);
            if (dRamp != 0.0) {
                double dLastTime = dTotalTime;
                this.contentPane.m_GraphControlTemp.AddDataPoint(iIdealPlotIndex, (dTotalTime += (dFinalTemp - dLastTemp) / dRamp) * 60.0, dFinalTemp);
                int j = 1;
                while (j < 500) {
                    double dTime = (dTotalTime - dLastTime) * ((double)j / 500.0) + dLastTime;
                    double dTemperature = (dFinalTemp - dLastTemp) * ((double)j / 500.0) + dLastTemp;
                    this.contentPane.m_GraphControlHoldUp.AddDataPoint(iIdealPlotIndexHoldUp, dTime * 60.0, this.m_InitialInterpolatedHoldUpVsTempProfile.getAt(dTemperature));
                    ++j;
                }
            }
            if (dFinalTime != 0.0) {
                this.contentPane.m_GraphControlTemp.AddDataPoint(iIdealPlotIndex, (dTotalTime += dFinalTime) * 60.0, dFinalTemp);
                this.contentPane.m_GraphControlHoldUp.AddDataPoint(iIdealPlotIndexHoldUp, dTotalTime * 60.0, this.m_InitialInterpolatedHoldUpVsTempProfile.getAt(dFinalTemp));
            }
            dLastTemp = dFinalTemp;
            ++i4;
        }
        if (this.contentPane.tmTemperatureProgram.getRowCount() > 0) {
            this.contentPane.m_GraphControlTemp.AddDataPoint(iIdealPlotIndex, this.m_dPlotXMax * 60.0, dFinalTemp);
            this.contentPane.m_GraphControlHoldUp.AddDataPoint(iIdealPlotIndexHoldUp, this.m_dPlotXMax * 60.0, this.m_InitialInterpolatedHoldUpVsTempProfile.getAt(dFinalTemp));
        } else {
            this.contentPane.m_GraphControlTemp.AddDataPoint(iIdealPlotIndex, this.m_dPlotXMax * 60.0, this.m_dInitialTemperature);
            this.contentPane.m_GraphControlHoldUp.AddDataPoint(iIdealPlotIndexHoldUp, this.m_dPlotXMax * 60.0, this.m_InitialInterpolatedHoldUpVsTempProfile.getAt(this.m_dInitialTemperature));
        }
        this.contentPane.m_GraphControlTemp.AutoScaleX();
        this.contentPane.m_GraphControlTemp.AutoScaleY();
        this.contentPane.m_GraphControlTemp.repaint();
        this.contentPane.m_GraphControlHoldUp.AutoScaleX();
        this.contentPane.m_GraphControlHoldUp.AutoScaleY();
        this.contentPane.m_GraphControlHoldUp.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.performValidations();
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.performValidations();
    }

    @Override
    public void autoScaleChanged(AutoScaleEvent event) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.m_bDoNotChangeTable) {
            this.m_bDoNotChangeTable = false;
            return;
        }
        if (e.getSource() == this.contentPane.tmTemperatureProgram) {
            double dTemp;
            int row = e.getFirstRow();
            int column = e.getColumn();
            if (column == 0) {
                Double dNewValue = (Double)this.contentPane.tmTemperatureProgram.getValueAt(row, 0);
                dTemp = dNewValue;
                if (dTemp < 0.0) {
                    dTemp = 0.0;
                }
                if (dTemp > 1000.0) {
                    dTemp = 1000.0;
                }
                this.m_bDoNotChangeTable = true;
                this.contentPane.tmTemperatureProgram.setValueAt(dTemp, row, column);
            } else if (column == 1) {
                Double dNewValue = (Double)this.contentPane.tmTemperatureProgram.getValueAt(row, 1);
                dTemp = dNewValue;
                if (dTemp < 0.0) {
                    dTemp = 0.0;
                }
                if (dTemp > 500.0) {
                    dTemp = 500.0;
                }
                if (row == 0 && dTemp < Double.valueOf(this.m_dInitialTemperature)) {
                    dTemp = this.m_dInitialTemperature;
                }
                if (row < this.contentPane.tmTemperatureProgram.getRowCount() - 1 && dTemp > (Double)this.contentPane.tmTemperatureProgram.getValueAt(row + 1, column)) {
                    dTemp = (Double)this.contentPane.tmTemperatureProgram.getValueAt(row + 1, column);
                }
                if (row > 0 && dTemp < (Double)this.contentPane.tmTemperatureProgram.getValueAt(row - 1, column)) {
                    dTemp = (Double)this.contentPane.tmTemperatureProgram.getValueAt(row - 1, column);
                }
                this.m_bDoNotChangeTable = true;
                this.contentPane.tmTemperatureProgram.setValueAt(dTemp, row, column);
            } else if (column == 2) {
                Double dNewValue = (Double)this.contentPane.tmTemperatureProgram.getValueAt(row, 2);
                dTemp = dNewValue;
                if (dTemp < 0.0) {
                    dTemp = 0.0;
                }
                if (dTemp > 1000.0) {
                    dTemp = 1000.0;
                }
                this.m_bDoNotChangeTable = true;
                this.contentPane.tmTemperatureProgram.setValueAt(dTemp, row, column);
            }
        } else if (e.getSource() == this.contentPane.tmMeasuredRetentionTimes) {
            int iChangedRow = e.getFirstRow();
            int iChangedColumn = e.getColumn();
            if (iChangedColumn == 3) {
                double dNewValue;
                if (this.contentPane.tmMeasuredRetentionTimes.getValueAt(iChangedRow, 3) == null) {
                    this.m_bDoNotChangeTable = true;
                    this.contentPane.tmMeasuredRetentionTimes.setValueAt(0.0, iChangedRow, 3);
                }
                if ((dNewValue = ((Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(iChangedRow, 3)).doubleValue()) < 0.0) {
                    dNewValue = 0.0;
                }
                if (dNewValue > 9999999.0) {
                    dNewValue = 9999999.0;
                }
                this.m_bDoNotChangeTable = true;
                this.contentPane.tmMeasuredRetentionTimes.setValueAt(dNewValue, iChangedRow, 3);
                this.m_bDoNotChangeTable = true;
                if (dNewValue <= 0.0) {
                    this.contentPane.tmMeasuredRetentionTimes.setValueAt(false, iChangedRow, 0);
                } else {
                    this.contentPane.tmMeasuredRetentionTimes.setValueAt(true, iChangedRow, 0);
                }
            }
        }
        this.performValidations();
        this.contentPane.m_GraphControlTemp.removeAllLineMarkers();
        this.contentPane.m_GraphControlHoldUp.removeAllLineMarkers();
        int i = 0;
        while (i < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
            if (((Boolean)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 0)).booleanValue()) {
                this.contentPane.m_GraphControlTemp.addLineMarker((Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3), (String)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1));
                this.contentPane.m_GraphControlHoldUp.addLineMarker((Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3), (String)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1));
            }
            ++i;
        }
        this.contentPane.m_GraphControlTemp.repaint();
        this.contentPane.m_GraphControlHoldUp.repaint();
        int iNumUsed = 0;
        int i2 = 0;
        while (i2 < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
            if (((Boolean)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i2, 0)).booleanValue()) {
                ++iNumUsed;
            }
            ++i2;
        }
        if (iNumUsed >= 6) {
            this.contentPane.jbtnNextStep.setEnabled(true);
        } else {
            this.contentPane.jbtnNextStep.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraphs(boolean bAlsoUpdateTable) {
        Object object = this.contentPane2.m_GraphControlTemp.lockObject;
        synchronized (object) {
            Object object2 = this.contentPane2.m_GraphControlHoldUp.lockObject;
            synchronized (object2) {
                this.contentPane2.m_GraphControlTemp.RemoveSeries(this.m_iInterpolatedTempProgramSeries);
                this.contentPane2.m_GraphControlTemp.RemoveSeries(this.m_iTempProgramMarkerSeries);
                this.contentPane2.m_GraphControlHoldUp.RemoveSeries(this.m_iInterpolatedHoldUpSeries);
                this.contentPane2.m_GraphControlHoldUp.RemoveSeries(this.m_iHoldUpMarkerSeries);
                this.m_iInterpolatedTempProgramSeries = this.contentPane2.m_GraphControlTemp.AddSeries("Interpolated Gradient", new Color(255, 0, 0), 1, false, false);
                this.m_iTempProgramMarkerSeries = this.contentPane2.m_GraphControlTemp.AddSeries("Gradient Markers", new Color(255, 0, 0), 1, true, false);
                this.m_iInterpolatedHoldUpSeries = this.contentPane2.m_GraphControlHoldUp.AddSeries("Interpolated Flow", new Color(255, 0, 0), 1, false, false);
                this.m_iHoldUpMarkerSeries = this.contentPane2.m_GraphControlHoldUp.AddSeries("Flow Rate Markers", new Color(255, 0, 0), 1, true, false);
                double dMinTemp = this.m_dHoldUpArray[0][0];
                double dMaxTemp = this.m_dHoldUpArray[this.m_dHoldUpArray.length - 1][0];
                int iNumPoints = 1000;
                int i = 0;
                while (i < iNumPoints) {
                    double dXPos = (double)i / (double)(iNumPoints - 1) * (this.m_dPlotXMax2 * 60.0);
                    this.contentPane2.m_GraphControlTemp.AddDataPoint(this.m_iInterpolatedTempProgramSeries, dXPos, this.m_InterpolatedTemperatureProfile.getAt(dXPos / 60.0));
                    dXPos = (double)i / (double)(iNumPoints - 1) * (dMaxTemp - dMinTemp) + dMinTemp;
                    this.contentPane2.m_GraphControlHoldUp.AddDataPoint(this.m_iInterpolatedHoldUpSeries, dXPos, this.m_InterpolatedHoldUp.getAt(dXPos));
                    ++i;
                }
                i = 0;
                while (i < this.m_dTemperatureProfileArray.length) {
                    this.contentPane2.m_GraphControlTemp.AddDataPoint(this.m_iTempProgramMarkerSeries, this.m_dTemperatureProfileArray[i][0] * 60.0, this.m_dTemperatureProfileArray[i][1]);
                    ++i;
                }
                i = 0;
                while (i < this.m_dHoldUpArray.length) {
                    this.contentPane2.m_GraphControlHoldUp.AddDataPoint(this.m_iHoldUpMarkerSeries, this.m_dHoldUpArray[i][0], this.m_dHoldUpArray[i][1]);
                    ++i;
                }
                this.contentPane2.m_GraphControlTemp.AutoScaleX();
                this.contentPane2.m_GraphControlTemp.AutoScaleY();
                this.contentPane2.m_GraphControlHoldUp.AutoScaleX();
                this.contentPane2.m_GraphControlHoldUp.AutoScaleY();
                this.contentPane2.m_GraphControlTemp.repaint();
                this.contentPane2.m_GraphControlHoldUp.repaint();
                if (bAlsoUpdateTable) {
                    DecimalFormat formatter = new DecimalFormat("#0.0000");
                    int i2 = 0;
                    while (i2 < this.m_vectCalCompounds.size()) {
                        double dMeasuredTime = (Double)this.m_vectCalCompounds.get(i2)[1];
                        double dPredictedTime = (Double)this.m_vectCalCompounds.get(i2)[2];
                        if (dMeasuredTime >= 0.0) {
                            this.contentPane2.tmOutputModel.setValueAt(formatter.format(dPredictedTime), i2, 2);
                            this.contentPane2.tmOutputModel.setValueAt(formatter.format(dPredictedTime - dMeasuredTime), i2, 3);
                        } else {
                            this.contentPane2.tmOutputModel.setValueAt("Did not elute", i2, 2);
                            this.contentPane2.tmOutputModel.setValueAt("-", i2, 3);
                        }
                        ++i2;
                    }
                }
            }
        }
    }

    public void beginBackCalculation(boolean bFlowRateProfileBackCalculationFirst) {
        this.contentPane2.jbtnCalculate.setEnabled(false);
        this.contentPane2.jProgressBar.setIndeterminate(true);
        this.contentPane2.jProgressBar.setStringPainted(true);
        this.contentPane2.jProgressBar.setString("Please wait, optimization in progress...");
        this.task = new Task();
        this.task.setOptimizationOrder(bFlowRateProfileBackCalculationFirst);
        this.task.execute();
    }

    public double calcRetentionError(double dtstep, int iNumCompoundsToInclude) {
        double dRetentionError = 0.0;
        int iCompound = 0;
        while (iCompound < iNumCompoundsToInclude) {
            double dtRFinal = 0.0;
            double dXPosition = 0.0;
            double dLastXPosition = 0.0;
            double dXMovement = 0.0;
            boolean bIsEluted = false;
            double dTcA = 0.0;
            double dTcB = 0.0;
            double dCurVal = 0.0;
            dTcA = this.m_InterpolatedTemperatureProfile.getAt(0.0);
            double t = 0.0;
            while (t <= (Double)this.m_vectCalCompounds.get(this.m_vectCalCompounds.size() - 1)[1] * 1.5) {
                dTcB = this.m_InterpolatedTemperatureProfile.getAt(t + dtstep);
                double dTc = (dTcA + dTcB) / 2.0;
                double dHc = this.m_InterpolatedHoldUp.getAt(dTc) / 60.0;
                dCurVal = dtstep / (1.0 + Math.pow(10.0, this.m_AlkaneIsothermalDataInterpolated[iCompound].getAt(dTc)));
                dXMovement = dCurVal / dHc;
                dLastXPosition = dXPosition;
                if ((dXPosition += dXMovement) >= 1.0) {
                    dtRFinal = (1.0 - dLastXPosition) / (dXPosition - dLastXPosition) * dtstep + t;
                    bIsEluted = true;
                    break;
                }
                dTcA = dTcB;
                t += dtstep;
            }
            if (bIsEluted) {
                dRetentionError += Math.pow(dtRFinal - (Double)this.m_vectCalCompounds.get(iCompound)[1], 2.0);
                this.m_vectCalCompounds.get((int)iCompound)[2] = dtRFinal;
            } else {
                dRetentionError += Math.pow((Double)this.m_vectCalCompounds.get(iCompound)[1], 2.0);
                this.m_vectCalCompounds.get((int)iCompound)[2] = -1;
            }
            ++iCompound;
        }
        return dRetentionError;
    }

    public void updateTime(long starttime) {
        DecimalFormat timeformatter = new DecimalFormat("00");
        long currentTime = System.currentTimeMillis();
        long lNumSecondsPassed = (currentTime - starttime) / 1000L;
        long lNumDaysPassed = lNumSecondsPassed / 86400L;
        long lNumHoursPassed = (lNumSecondsPassed -= lNumDaysPassed * 86400L) / 3600L;
        long lNumMinutesPassed = (lNumSecondsPassed -= lNumHoursPassed * 3600L) / 60L;
        String strProgress2 = "";
        strProgress2 = String.valueOf(strProgress2) + timeformatter.format(lNumHoursPassed) + ":" + timeformatter.format(lNumMinutesPassed) + ":" + timeformatter.format(lNumSecondsPassed -= lNumMinutesPassed * 60L);
        this.contentPane2.jlblTimeElapsed.setText(strProgress2);
    }

    public double calcAngleDifferenceHoldUp(int iIndex) {
        double dTotalAngleError = 0.0;
        double dHoldUpRange = 20.0;
        int i = 0;
        while (i < this.m_dHoldUpArray.length) {
            if (i >= 2) {
                double dTime2 = this.m_dHoldUpArray[i][0];
                double dHoldUp2 = this.m_dHoldUpArray[i][1];
                double dTime1 = this.m_dHoldUpArray[i - 1][0];
                double dHoldUp1 = this.m_dHoldUpArray[i - 1][1];
                double dTime0 = this.m_dHoldUpArray[i - 2][0];
                double dHoldUp0 = this.m_dHoldUpArray[i - 2][1];
                double dPreviousAdjacent = (dHoldUp1 - dHoldUp0) / dHoldUpRange;
                double dPreviousOpposite = dTime1 - dTime0;
                double dPreviousAngle = dPreviousAdjacent == 0.0 ? 1.5707963267948966 : Math.atan(dPreviousOpposite / dPreviousAdjacent);
                if (dPreviousAngle < 0.0) {
                    dPreviousAngle += Math.PI;
                }
                double dAdjacent = (dHoldUp2 - dHoldUp1) / dHoldUpRange;
                double dOpposite = dTime2 - dTime1;
                double dNewAngle = dAdjacent == 0.0 ? 1.5707963267948966 : Math.atan(dOpposite / dAdjacent);
                if (dNewAngle < 0.0) {
                    dNewAngle += Math.PI;
                }
                double dFactor1 = 300.0;
                double dAngleError = Math.pow(Math.abs(dNewAngle - dPreviousAngle) / Math.PI * dFactor1, 2.0) + 1.0;
                dTotalAngleError += dAngleError;
            }
            ++i;
        }
        return dTotalAngleError;
    }

    public double calcAngleDifferenceTemp(int iIndex) {
        double dTotalAngleError = 0.0;
        double dMaxRampRate = 70.0;
        int i = 0;
        while (i < this.m_dTemperatureProfileArray.length) {
            if (i >= 2) {
                double dTime2 = this.m_dTemperatureProfileArray[i][0];
                double dTemp2 = this.m_dTemperatureProfileArray[i][1];
                double dTime1 = this.m_dTemperatureProfileArray[i - 1][0];
                double dTemp1 = this.m_dTemperatureProfileArray[i - 1][1];
                double dTime0 = this.m_dTemperatureProfileArray[i - 2][0];
                double dTemp0 = this.m_dTemperatureProfileArray[i - 2][1];
                boolean bIsCorner = false;
                int j = 0;
                while (j < this.m_dIdealTemperatureProfileArray.length - 1) {
                    if (this.m_dIdealTemperatureProfileArray[j][0] == dTime1) {
                        bIsCorner = true;
                        break;
                    }
                    ++j;
                }
                if (!bIsCorner) {
                    double dPreviousAdjacent = (dTemp1 - dTemp0) / dMaxRampRate;
                    double dPreviousOpposite = dTime1 - dTime0;
                    double dPreviousAngle = dPreviousAdjacent == 0.0 ? 1.5707963267948966 : Math.atan(dPreviousOpposite / dPreviousAdjacent);
                    if (dPreviousAngle < 0.0) {
                        dPreviousAngle += Math.PI;
                    }
                    double dAdjacent = (dTemp2 - dTemp1) / dMaxRampRate;
                    double dOpposite = dTime2 - dTime1;
                    double dNewAngle = dAdjacent == 0.0 ? 1.5707963267948966 : Math.atan(dOpposite / dAdjacent);
                    if (dNewAngle < 0.0) {
                        dNewAngle += Math.PI;
                    }
                    double dFactor1 = 25.0;
                    double dAngleError = Math.pow(Math.abs(dNewAngle - dPreviousAngle) / Math.PI * dFactor1, 2.0) + 1.0;
                    dTotalAngleError += dAngleError;
                }
            }
            ++i;
        }
        return dTotalAngleError;
    }

    /*
     * Unable to fully structure code
     */
    public double goldenSectioningSearchTemperatureProfile(int iIndex, double dStep, double dPrecision, double dMaxChangeAtOnce, boolean bMinimizeAngles) {
        dRetentionError = 1.0;
        dLastTempGuess = this.m_dTemperatureProfileArray[iIndex][1];
        x1 = this.m_dTemperatureProfileArray[iIndex][1];
        dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        dAngleErrorX1 = bMinimizeAngles != false ? this.calcAngleDifferenceTemp(iIndex) : 1.0;
        this.m_dTemperatureProfileArray[iIndex][1] = x2 = x1 + dStep;
        this.m_InterpolatedTemperatureProfile = new LinearInterpolationFunction(this.m_dTemperatureProfileArray);
        dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        if (dRetentionErrorX2 * (dAngleErrorX2 = bMinimizeAngles != false ? this.calcAngleDifferenceTemp(iIndex) : 1.0) < dRetentionErrorX1 * dAngleErrorX1) {
            x3 = x2;
            dRetentionErrorX3 = dRetentionErrorX2;
            dAngleErrorX3 = dAngleErrorX2;
            this.m_dTemperatureProfileArray[iIndex][1] = x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
            this.m_InterpolatedTemperatureProfile = new LinearInterpolationFunction(this.m_dTemperatureProfileArray);
            dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            dAngleErrorX2 = bMinimizeAngles ? this.calcAngleDifferenceTemp(iIndex) : 1.0;
            while (dRetentionErrorX2 * dAngleErrorX2 < dRetentionErrorX3 * dAngleErrorX3 && x2 < dLastTempGuess + dMaxChangeAtOnce) {
                x1 = x3;
                dRetentionErrorX1 = dRetentionErrorX3;
                dAngleErrorX1 = dAngleErrorX3;
                x3 = x2;
                dRetentionErrorX3 = dRetentionErrorX2;
                dAngleErrorX3 = dAngleErrorX2;
                this.m_dTemperatureProfileArray[iIndex][1] = x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
                this.m_InterpolatedTemperatureProfile = new LinearInterpolationFunction(this.m_dTemperatureProfileArray);
                dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
                dAngleErrorX2 = bMinimizeAngles != false ? this.calcAngleDifferenceTemp(iIndex) : 1.0;
            }
        } else {
            x3 = x1;
            dRetentionErrorX3 = dRetentionErrorX1;
            dAngleErrorX3 = dAngleErrorX1;
            this.m_dTemperatureProfileArray[iIndex][1] = x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
            this.m_InterpolatedTemperatureProfile = new LinearInterpolationFunction(this.m_dTemperatureProfileArray);
            dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            dAngleErrorX1 = bMinimizeAngles ? this.calcAngleDifferenceTemp(iIndex) : 1.0;
            while (dRetentionErrorX1 * dAngleErrorX1 < dRetentionErrorX3 * dAngleErrorX3 && x1 > dLastTempGuess - dMaxChangeAtOnce) {
                x2 = x3;
                dRetentionErrorX2 = dRetentionErrorX3;
                dAngleErrorX2 = dAngleErrorX3;
                x3 = x1;
                dRetentionErrorX3 = dRetentionErrorX1;
                dAngleErrorX3 = dAngleErrorX1;
                this.m_dTemperatureProfileArray[iIndex][1] = x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
                this.m_InterpolatedTemperatureProfile = new LinearInterpolationFunction(this.m_dTemperatureProfileArray);
                dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
                dAngleErrorX1 = bMinimizeAngles != false ? this.calcAngleDifferenceTemp(iIndex) : 1.0;
            }
        }
        if (x2 > dLastTempGuess + dMaxChangeAtOnce) {
            this.m_dTemperatureProfileArray[iIndex][1] = dLastTempGuess + dMaxChangeAtOnce;
            this.m_InterpolatedTemperatureProfile = new LinearInterpolationFunction(this.m_dTemperatureProfileArray);
            dRetentionError = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            return dRetentionError;
        }
        if (!(x1 < dLastTempGuess - dMaxChangeAtOnce)) ** GOTO lbl87
        this.m_dTemperatureProfileArray[iIndex][1] = dLastTempGuess - dMaxChangeAtOnce;
        this.m_InterpolatedTemperatureProfile = new LinearInterpolationFunction(this.m_dTemperatureProfileArray);
        dRetentionError = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        return dRetentionError;
lbl-1000:
        // 1 sources

        {
            x4 = x2 - x3 > x3 - x1 ? x3 + (2.0 - this.m_dGoldenRatio) * (x2 - x3) : x3 - (2.0 - this.m_dGoldenRatio) * (x3 - x1);
            this.m_dTemperatureProfileArray[iIndex][1] = x4;
            this.m_InterpolatedTemperatureProfile = new LinearInterpolationFunction(this.m_dTemperatureProfileArray);
            dRetentionErrorX4 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            if (dRetentionErrorX4 * (dAngleErrorX4 = bMinimizeAngles != false ? this.calcAngleDifferenceTemp(iIndex) : 1.0) < dRetentionErrorX3 * dAngleErrorX3) {
                if (x2 - x3 > x3 - x1) {
                    x1 = x3;
                    dRetentionErrorX1 = dRetentionErrorX3;
                    dAngleErrorX1 = dAngleErrorX3;
                    x3 = x4;
                    dRetentionErrorX3 = dRetentionErrorX4;
                    dAngleErrorX3 = dAngleErrorX4;
                    continue;
                }
                x2 = x3;
                dRetentionErrorX2 = dRetentionErrorX3;
                dAngleErrorX2 = dAngleErrorX3;
                x3 = x4;
                dRetentionErrorX3 = dRetentionErrorX4;
                dAngleErrorX3 = dAngleErrorX4;
                continue;
            }
            if (x2 - x3 > x3 - x1) {
                x2 = x4;
                dRetentionErrorX2 = dRetentionErrorX4;
                dAngleErrorX2 = dAngleErrorX4;
                continue;
            }
            x1 = x4;
            dRetentionErrorX1 = dRetentionErrorX4;
            dAngleErrorX1 = dAngleErrorX4;
lbl87:
            // 5 sources

            ** while (x2 - x1 > dPrecision)
        }
lbl88:
        // 1 sources

        this.m_dTemperatureProfileArray[iIndex][1] = x3;
        this.m_InterpolatedTemperatureProfile = new LinearInterpolationFunction(this.m_dTemperatureProfileArray);
        dRetentionError = dRetentionErrorX3;
        return dRetentionError;
    }

    /*
     * Unable to fully structure code
     */
    public double goldenSectioningSearchHoldUp(int iIndex, double dStep, double dPrecision, double dMaxChangeAtOnce, boolean bMinimizeAngles) {
        dRetentionError = 1.0;
        dLastFGuess = this.m_dHoldUpArray[iIndex][1];
        x1 = this.m_dHoldUpArray[iIndex][1];
        dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        dAngleErrorX1 = bMinimizeAngles != false ? this.calcAngleDifferenceHoldUp(iIndex) : 1.0;
        this.m_dHoldUpArray[iIndex][1] = x2 = x1 + dStep;
        this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
        dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        if (dRetentionErrorX2 * (dAngleErrorX2 = bMinimizeAngles != false ? this.calcAngleDifferenceHoldUp(iIndex) : 1.0) < dRetentionErrorX1 * dAngleErrorX1) {
            x3 = x2;
            dRetentionErrorX3 = dRetentionErrorX2;
            dAngleErrorX3 = dAngleErrorX2;
            this.m_dHoldUpArray[iIndex][1] = x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
            this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
            dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            dAngleErrorX2 = bMinimizeAngles ? this.calcAngleDifferenceHoldUp(iIndex) : 1.0;
            while (dRetentionErrorX2 * dAngleErrorX2 < dRetentionErrorX3 * dAngleErrorX3 && x2 < dLastFGuess + dMaxChangeAtOnce) {
                x1 = x3;
                dRetentionErrorX1 = dRetentionErrorX3;
                dAngleErrorX1 = dAngleErrorX3;
                x3 = x2;
                dRetentionErrorX3 = dRetentionErrorX2;
                dAngleErrorX3 = dAngleErrorX2;
                this.m_dHoldUpArray[iIndex][1] = x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
                this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
                dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
                dAngleErrorX2 = bMinimizeAngles != false ? this.calcAngleDifferenceHoldUp(iIndex) : 1.0;
            }
        } else {
            x3 = x1;
            dRetentionErrorX3 = dRetentionErrorX1;
            dAngleErrorX3 = dAngleErrorX1;
            this.m_dHoldUpArray[iIndex][1] = x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
            this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
            dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            dAngleErrorX1 = bMinimizeAngles ? this.calcAngleDifferenceHoldUp(iIndex) : 1.0;
            while (dRetentionErrorX1 * dAngleErrorX1 < dRetentionErrorX3 * dAngleErrorX3 && x1 > dLastFGuess - dMaxChangeAtOnce) {
                x2 = x3;
                dRetentionErrorX2 = dRetentionErrorX3;
                dAngleErrorX2 = dAngleErrorX3;
                x3 = x1;
                dRetentionErrorX3 = dRetentionErrorX1;
                dAngleErrorX3 = dAngleErrorX1;
                this.m_dHoldUpArray[iIndex][1] = x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
                this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
                dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
                dAngleErrorX1 = bMinimizeAngles != false ? this.calcAngleDifferenceHoldUp(iIndex) : 1.0;
            }
        }
        if (x2 > dLastFGuess + dMaxChangeAtOnce) {
            this.m_dHoldUpArray[iIndex][1] = dLastFGuess + dMaxChangeAtOnce;
            this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
            dRetentionError = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            return dRetentionError;
        }
        if (!(x1 < dLastFGuess - dMaxChangeAtOnce)) ** GOTO lbl87
        this.m_dHoldUpArray[iIndex][1] = dLastFGuess - dMaxChangeAtOnce;
        this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
        dRetentionError = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        return dRetentionError;
lbl-1000:
        // 1 sources

        {
            x4 = x2 - x3 > x3 - x1 ? x3 + (2.0 - this.m_dGoldenRatio) * (x2 - x3) : x3 - (2.0 - this.m_dGoldenRatio) * (x3 - x1);
            this.m_dHoldUpArray[iIndex][1] = x4;
            this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
            dRetentionErrorX4 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            if (dRetentionErrorX4 * (dAngleErrorX4 = bMinimizeAngles != false ? this.calcAngleDifferenceHoldUp(iIndex) : 1.0) < dRetentionErrorX3 * dAngleErrorX3) {
                if (x2 - x3 > x3 - x1) {
                    x1 = x3;
                    dRetentionErrorX1 = dRetentionErrorX3;
                    dAngleErrorX1 = dAngleErrorX3;
                    x3 = x4;
                    dRetentionErrorX3 = dRetentionErrorX4;
                    dAngleErrorX3 = dAngleErrorX4;
                    continue;
                }
                x2 = x3;
                dRetentionErrorX2 = dRetentionErrorX3;
                dAngleErrorX2 = dAngleErrorX3;
                x3 = x4;
                dRetentionErrorX3 = dRetentionErrorX4;
                dAngleErrorX3 = dAngleErrorX4;
                continue;
            }
            if (x2 - x3 > x3 - x1) {
                x2 = x4;
                dRetentionErrorX2 = dRetentionErrorX4;
                dAngleErrorX2 = dAngleErrorX4;
                continue;
            }
            x1 = x4;
            dRetentionErrorX1 = dRetentionErrorX4;
            dAngleErrorX1 = dAngleErrorX4;
lbl87:
            // 5 sources

            ** while (x2 - x1 > dPrecision)
        }
lbl88:
        // 1 sources

        this.m_dHoldUpArray[iIndex][1] = x3;
        this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
        dRetentionError = dRetentionErrorX3;
        return dRetentionError;
    }

    public double goldenSectioningSearchHoldUpOffset(double dStep, double dPrecision, int iNumCompoundsToUse) {
        double dRetentionErrorF3;
        double F3;
        double dRetentionError = 1.0;
        double F1 = this.m_dHoldUpArray[0][1];
        double dRetentionErrorF1 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
        double F2 = F1 + dStep;
        double dDiff = F2 - this.m_dHoldUpArray[0][1];
        int i = 0;
        while (i < this.m_dHoldUpArray.length) {
            double[] dArray = this.m_dHoldUpArray[i];
            dArray[1] = dArray[1] + dDiff;
            ++i;
        }
        this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
        double dRetentionErrorF2 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
        if (dRetentionErrorF2 < dRetentionErrorF1) {
            F3 = F2;
            dRetentionErrorF3 = dRetentionErrorF2;
            F2 = (F3 - F1) * this.m_dGoldenRatio + F3;
            dDiff = F2 - this.m_dHoldUpArray[0][1];
            i = 0;
            while (i < this.m_dHoldUpArray.length) {
                double[] dArray = this.m_dHoldUpArray[i];
                dArray[1] = dArray[1] + dDiff;
                ++i;
            }
            this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
            dRetentionErrorF2 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
            while (dRetentionErrorF2 < dRetentionErrorF3) {
                F1 = F3;
                dRetentionErrorF1 = dRetentionErrorF3;
                F3 = F2;
                dRetentionErrorF3 = dRetentionErrorF2;
                F2 = (F3 - F1) * this.m_dGoldenRatio + F3;
                dDiff = F2 - this.m_dHoldUpArray[0][1];
                i = 0;
                while (i < this.m_dHoldUpArray.length) {
                    double[] dArray = this.m_dHoldUpArray[i];
                    dArray[1] = dArray[1] + dDiff;
                    ++i;
                }
                this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
                dRetentionErrorF2 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
            }
        } else {
            F3 = F1;
            dRetentionErrorF3 = dRetentionErrorF1;
            F1 = F3 - (F2 - F3) * this.m_dGoldenRatio;
            dDiff = F1 - this.m_dHoldUpArray[0][1];
            i = 0;
            while (i < this.m_dHoldUpArray.length) {
                double[] dArray = this.m_dHoldUpArray[i];
                dArray[1] = dArray[1] + dDiff;
                ++i;
            }
            this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
            dRetentionErrorF1 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
            while (dRetentionErrorF1 < dRetentionErrorF3) {
                F2 = F3;
                dRetentionErrorF2 = dRetentionErrorF3;
                F3 = F1;
                dRetentionErrorF3 = dRetentionErrorF1;
                F1 = F3 - (F2 - F3) * this.m_dGoldenRatio;
                dDiff = F1 - this.m_dHoldUpArray[0][1];
                i = 0;
                while (i < this.m_dHoldUpArray.length) {
                    double[] dArray = this.m_dHoldUpArray[i];
                    dArray[1] = dArray[1] + dDiff;
                    ++i;
                }
                this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
                dRetentionErrorF1 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
            }
        }
        while (F2 - F1 > dPrecision) {
            double F4 = F2 - F3 > F3 - F1 ? F3 + (2.0 - this.m_dGoldenRatio) * (F2 - F3) : F3 - (2.0 - this.m_dGoldenRatio) * (F3 - F1);
            dDiff = F4 - this.m_dHoldUpArray[0][1];
            int i2 = 0;
            while (i2 < this.m_dHoldUpArray.length) {
                double[] dArray = this.m_dHoldUpArray[i2];
                dArray[1] = dArray[1] + dDiff;
                ++i2;
            }
            this.m_InterpolatedHoldUp = new InterpolationFunction(this.m_dHoldUpArray);
            double dRetentionErrorF4 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
            if (dRetentionErrorF4 < dRetentionErrorF3) {
                if (F2 - F3 > F3 - F1) {
                    F1 = F3;
                    dRetentionErrorF1 = dRetentionErrorF3;
                    F3 = F4;
                    dRetentionErrorF3 = dRetentionErrorF4;
                    continue;
                }
                F2 = F3;
                dRetentionErrorF2 = dRetentionErrorF3;
                F3 = F4;
                dRetentionErrorF3 = dRetentionErrorF4;
                continue;
            }
            if (F2 - F3 > F3 - F1) {
                F2 = F4;
                dRetentionErrorF2 = dRetentionErrorF4;
                continue;
            }
            F1 = F4;
            dRetentionErrorF1 = dRetentionErrorF4;
        }
        dRetentionError = dRetentionErrorF3;
        return dRetentionError;
    }

    public void backCalculate(Task task, boolean bHoldUpProfileFirst) {
        long starttime = System.currentTimeMillis();
        this.m_dTemperatureArrayStore = new double[300][this.m_dTemperatureProfileArray.length][2];
        this.m_dHoldUpArrayStore = new double[300][this.m_dHoldUpArray.length][2];
        this.m_dRetentionErrorStore = new double[300];
        boolean bBackCalculateTempProfile = false;
        boolean bBackCalculateHoldUpProfile = false;
        boolean bMinimizeAnglesTempProfile = true;
        boolean bMinimizeAnglesHoldUpProfile = true;
        this.m_dtstep = this.m_dPlotXMax2 * 0.01;
        if (bHoldUpProfileFirst) {
            bBackCalculateTempProfile = false;
            bBackCalculateHoldUpProfile = true;
        } else {
            bBackCalculateTempProfile = true;
            bBackCalculateHoldUpProfile = false;
        }
        DecimalFormat formatter1 = new DecimalFormat("#0.000000");
        DecimalFormat formatter2 = new DecimalFormat("0.0000E0");
        DecimalFormat percentFormatter = new DecimalFormat("0.00");
        this.m_AlkaneIsothermalDataInterpolated = new InterpolationFunction[this.contentPane2.tmOutputModel.getRowCount()];
        int i = 0;
        while (i < this.m_AlkaneIsothermalDataInterpolated.length) {
            Integer iIndex = (Integer)this.m_vectCalCompounds.get(i)[0];
            this.m_AlkaneIsothermalDataInterpolated[i] = new InterpolationFunction(Globals.AlkaneIsothermalDataArray[iIndex]);
            ++i;
        }
        double dHoldUpStep = 0.1;
        double dHoldUpPrecision = 1.0E-4;
        int iNumCompoundsToUse = 3;
        double dRetentionError = this.goldenSectioningSearchHoldUpOffset(dHoldUpStep, dHoldUpPrecision, iNumCompoundsToUse);
        this.updateTime(starttime);
        double dNum = dRetentionError / (double)this.m_vectCalCompounds.size();
        String str = dNum < 1.0E-4 ? formatter2.format(dNum) : formatter1.format(dNum);
        this.contentPane2.jlblVariance.setText(str);
        this.updateGraphs(true);
        if (task.isCancelled()) {
            return;
        }
        int iPhase = 1;
        int iIteration = 0;
        double dLastFullIterationError = 0.0;
        double dRetentionError2 = 0.0;
        while (true) {
            double dNum2;
            String str2;
            double dNum3;
            int iTimePoint;
            this.contentPane2.jlblIterationNumber.setText(Integer.valueOf(++iIteration).toString());
            dLastFullIterationError = dRetentionError2;
            if (bBackCalculateHoldUpProfile) {
                iTimePoint = 0;
                while (iTimePoint < this.m_dHoldUpArray.length) {
                    double dHoldUpStep2 = 0.1;
                    double dHoldUpPrecision2 = 1.0E-4;
                    double dMaxChangeAtOnce = 2.0;
                    dRetentionError2 = this.goldenSectioningSearchHoldUp(iTimePoint, dHoldUpStep2, dHoldUpPrecision2, dMaxChangeAtOnce, bMinimizeAnglesHoldUpProfile);
                    this.updateTime(starttime);
                    dNum3 = dRetentionError2 / (double)this.m_vectCalCompounds.size();
                    str2 = dNum3 < 1.0E-4 ? formatter2.format(dNum3) : formatter1.format(dNum3);
                    this.contentPane2.jlblVariance.setText(str2);
                    this.updateGraphs(true);
                    if (task.isCancelled()) {
                        return;
                    }
                    ++iTimePoint;
                }
            }
            if (bBackCalculateTempProfile) {
                iTimePoint = 0;
                while (iTimePoint < this.m_dTemperatureProfileArray.length) {
                    double dTempStep = 0.5;
                    double dMaxChangeAtOnce = 5.0;
                    double dTempPrecision = 0.001;
                    dRetentionError2 = this.goldenSectioningSearchTemperatureProfile(iTimePoint, dTempStep, dTempPrecision, dMaxChangeAtOnce, bMinimizeAnglesTempProfile);
                    this.updateTime(starttime);
                    dNum3 = dRetentionError2 / (double)this.m_vectCalCompounds.size();
                    str2 = dNum3 < 1.0E-4 ? formatter2.format(dNum3) : formatter1.format(dNum3);
                    this.contentPane2.jlblVariance.setText(str2);
                    this.updateGraphs(true);
                    if (task.isCancelled()) {
                        return;
                    }
                    ++iTimePoint;
                }
            }
            String str3 = (dNum2 = dRetentionError2 / (double)this.m_vectCalCompounds.size()) == 0.0 ? "" : (dNum2 < 1.0E-4 ? formatter2.format(dNum2) : formatter1.format(dNum2));
            this.contentPane2.jlblLastVariance.setText(str3);
            int i2 = 0;
            while (i2 < this.m_dTemperatureProfileArray.length) {
                this.m_dTemperatureArrayStore[iIteration - 1][i2][0] = this.m_dTemperatureProfileArray[i2][0];
                this.m_dTemperatureArrayStore[iIteration - 1][i2][1] = this.m_dTemperatureProfileArray[i2][1];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.m_dHoldUpArray.length) {
                this.m_dHoldUpArrayStore[iIteration - 1][i2][0] = this.m_dHoldUpArray[i2][0];
                this.m_dHoldUpArrayStore[iIteration - 1][i2][1] = this.m_dHoldUpArray[i2][1];
                ++i2;
            }
            this.m_dRetentionErrorStore[iIteration - 1] = dRetentionError2;
            if (dLastFullIterationError == 0.0) continue;
            double dPercentImprovement = (1.0 - dRetentionError2 / dLastFullIterationError) * 100.0;
            this.contentPane2.jlblPercentImprovement.setText(String.valueOf(percentFormatter.format(dPercentImprovement)) + "%");
            if (iPhase == 1) {
                if (bHoldUpProfileFirst) {
                    if (!(dPercentImprovement < 5.0) || !(dPercentImprovement >= 0.0)) continue;
                    iPhase = 2;
                    this.contentPane2.jlblPhase.setText("II");
                    bBackCalculateTempProfile = true;
                    bBackCalculateHoldUpProfile = true;
                    bMinimizeAnglesTempProfile = true;
                    bMinimizeAnglesHoldUpProfile = true;
                    continue;
                }
                if (!(dPercentImprovement < 15.0) || !(dPercentImprovement >= 0.0)) continue;
                iPhase = 2;
                this.contentPane2.jlblPhase.setText("II");
                bBackCalculateTempProfile = true;
                bBackCalculateHoldUpProfile = true;
                bMinimizeAnglesTempProfile = true;
                bMinimizeAnglesHoldUpProfile = true;
                continue;
            }
            if (iPhase == 2) {
                if (!(dPercentImprovement < 2.0) || !(dPercentImprovement >= 0.0)) continue;
                iPhase = 3;
                this.contentPane2.jlblPhase.setText("III");
                if (bHoldUpProfileFirst) {
                    bBackCalculateTempProfile = true;
                    bBackCalculateHoldUpProfile = true;
                } else {
                    bBackCalculateTempProfile = true;
                    bBackCalculateHoldUpProfile = true;
                }
                bMinimizeAnglesTempProfile = false;
                bMinimizeAnglesHoldUpProfile = false;
                this.m_dtstep = this.m_dPlotXMax2 * 0.001;
                continue;
            }
            if (dPercentImprovement < 1.0 && dPercentImprovement >= 0.0) break;
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        private boolean bFlowRateProfileBackCalculationFirst = true;

        Task() {
        }

        public void setOptimizationOrder(boolean bFlowRateProfileBackCalculationFirst) {
            this.bFlowRateProfileBackCalculationFirst = bFlowRateProfileBackCalculationFirst;
        }

        @Override
        public Void doInBackground() {
            RetentionPredictorApplet.this.backCalculate(this, this.bFlowRateProfileBackCalculationFirst);
            return null;
        }

        @Override
        public void done() {
            RetentionPredictorApplet.this.contentPane2.jbtnNextStep.setEnabled(true);
            RetentionPredictorApplet.this.contentPane2.jProgressBar.setIndeterminate(false);
            RetentionPredictorApplet.this.contentPane2.jProgressBar.setStringPainted(true);
            RetentionPredictorApplet.this.contentPane2.jProgressBar.setString("Optimization complete! Continue to next step.");
        }
    }

    class TaskPredict
    extends SwingWorker<Void, Void> {
        TaskPredict() {
        }

        @Override
        public Void doInBackground() {
            DecimalFormat formatter1 = new DecimalFormat("#0.000");
            DecimalFormat formatter2 = new DecimalFormat("#0.0000");
            double dPercentErrorInk = 0.042;
            int iNumCompounds = Globals.CompoundIsothermalDataArray.length;
            int iCompound = 0;
            while (iCompound < iNumCompounds) {
                if (RetentionPredictorApplet.this.taskPredict.isCancelled()) {
                    return null;
                }
                InterpolationFunction IsocraticData = new InterpolationFunction(Globals.CompoundIsothermalDataArray[iCompound]);
                double dtRFinal = 0.0;
                double dXPosition = 0.0;
                double dLastXPosition = 0.0;
                double dXMovement = 0.0;
                Boolean bIsEluted = false;
                double dTcA = 0.0;
                double dTcB = 0.0;
                double dCurVal = 0.0;
                double[][] dFractionkMovedCompound = new double[][]{{0.0, 70.0, 0.0, 0.0, 0.0}, {70.0, 90.0, 0.0, 0.0, 0.0}, {90.0, 110.0, 0.0, 0.0, 0.0}, {110.0, 130.0, 0.0, 0.0, 0.0}, {130.0, 150.0, 0.0, 0.0, 0.0}, {150.0, 170.0, 0.0, 0.0, 0.0}, {170.0, 190.0, 0.0, 0.0, 0.0}, {190.0, 210.0, 0.0, 0.0, 0.0}, {210.0, 230.0, 0.0, 0.0, 0.0}, {230.0, 250.0, 0.0, 0.0, 0.0}, {250.0, 270.0, 0.0, 0.0, 0.0}, {270.0, 290.0, 0.0, 0.0, 0.0}, {290.0, 310.0, 0.0, 0.0, 0.0}, {310.0, 800.0, 0.0, 0.0, 0.0}};
                dTcA = RetentionPredictorApplet.this.m_InterpolatedTemperatureProfile.getAt(0.0);
                double t = 0.0;
                while (t <= (Double)RetentionPredictorApplet.this.m_vectCalCompounds.get(RetentionPredictorApplet.this.m_vectCalCompounds.size() - 1)[1] * 1.5) {
                    dTcB = RetentionPredictorApplet.this.m_InterpolatedTemperatureProfile.getAt(t + RetentionPredictorApplet.this.m_dtstep);
                    double dTc = (dTcA + dTcB) / 2.0;
                    int thisIndex = 0;
                    int i = 0;
                    while (i < dFractionkMovedCompound.length) {
                        if (dFractionkMovedCompound[i][0] <= dTc && dFractionkMovedCompound[i][1] > dTc) {
                            thisIndex = i;
                            break;
                        }
                        ++i;
                    }
                    double dHc = RetentionPredictorApplet.this.m_InterpolatedHoldUp.getAt(dTc) / 60.0;
                    dCurVal = RetentionPredictorApplet.this.m_dtstep / (1.0 + Math.pow(10.0, IsocraticData.getAt(dTc)));
                    dXMovement = dCurVal / dHc;
                    double[] dArray = dFractionkMovedCompound[thisIndex];
                    dArray[2] = dArray[2] + dXMovement;
                    double dBigFraction = (dFractionkMovedCompound[thisIndex][2] - dXMovement) / dFractionkMovedCompound[thisIndex][2];
                    double dSmallFraction = 1.0 - dBigFraction;
                    dFractionkMovedCompound[thisIndex][3] = dFractionkMovedCompound[thisIndex][3] * dBigFraction + Math.pow(10.0, IsocraticData.getAt(dTc)) * dHc * (dPercentErrorInk / 100.0) * dSmallFraction;
                    dFractionkMovedCompound[thisIndex][4] = dFractionkMovedCompound[thisIndex][4] * dBigFraction + Math.pow(10.0, IsocraticData.getAt(dTc)) * dSmallFraction;
                    dLastXPosition = dXPosition;
                    dXPosition += dXMovement;
                    if (dXPosition >= 1.0) {
                        dtRFinal = (1.0 - dLastXPosition) / (dXPosition - dLastXPosition) * RetentionPredictorApplet.this.m_dtstep + t;
                        bIsEluted = true;
                        break;
                    }
                    dTcA = dTcB;
                    t += RetentionPredictorApplet.this.m_dtstep;
                }
                if (bIsEluted.booleanValue()) {
                    RetentionPredictorApplet.this.contentPane2.tmPredictionModel.setValueAt(formatter1.format(dtRFinal), iCompound, 1);
                } else {
                    RetentionPredictorApplet.this.contentPane2.tmPredictionModel.setValueAt("Did not elute", iCompound, 1);
                }
                double dFinalError = 0.0;
                double dkavg = 0.0;
                int i = 0;
                while (i < dFractionkMovedCompound.length) {
                    dFinalError += Math.pow(dFractionkMovedCompound[i][3] * dFractionkMovedCompound[i][2], 2.0);
                    dkavg += dFractionkMovedCompound[i][4] * dFractionkMovedCompound[i][2];
                    ++i;
                }
                dFinalError = Math.sqrt(dFinalError);
                RetentionPredictorApplet.this.contentPane2.tmPredictionModel.setValueAt(formatter2.format(dFinalError), iCompound, 2);
                ++iCompound;
            }
            return null;
        }

        @Override
        public void done() {
            RetentionPredictorApplet.this.contentPane2.jProgressBar2.setIndeterminate(false);
            RetentionPredictorApplet.this.contentPane2.jProgressBar2.setStringPainted(true);
            RetentionPredictorApplet.this.contentPane2.jProgressBar2.setString("Retention predictions complete.");
        }
    }
}

